VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3120
   ClientLeft      =   60
   ClientTop       =   420
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   3120
   ScaleWidth      =   4680
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.CommandButton Command1 
      Caption         =   "Create PDF"
      Height          =   855
      Left            =   960
      TabIndex        =   0
      Top             =   960
      Width           =   2775
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Declare Function GetFullPathName Lib "kernel32" Alias "GetFullPathNameW" (ByVal lpFileName As Long, ByVal nBufferLength As Long, ByVal lpBuffer As Long, ByVal lpFilePart As Long) As Long
Private Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

Public WithEvents pdf As CPDF 'Activate event support
Attribute pdf.VB_VarHelpID = -1

Function GetFullPath(ByVal Path As String) As String
   Dim sLen As Long
   GetFullPath = Space(512)
   sLen = GetFullPathName(StrPtr(Path), 511, StrPtr(GetFullPath), 0)
   GetFullPath = Left(GetFullPath, sLen)
End Function

Private Sub PDF_Error(ByVal Description As String, ByVal ErrType As Long, DoBreak As Boolean)
   MsgBox Description, vbExclamation, "Error"
   DoBreak = False ' Try to continue
End Sub


Private Function ConvertFile(ByVal ConfType As TConformanceType, ByVal InFile As String, ByVal Invoice As String, ByVal OutFile As String) As Boolean
   Dim retval As Long
   Dim convFlags As Long
   
   ConvertFile = False
   
   convFlags = TCheckOptions.coDefault_PDFA_3

   Select Case ConfType
      Case TConformanceType.ctFacturX_Comfort, TConformanceType.ctFacturX_Extended, TConformanceType.ctFacturX_XRechnung
         ' Ok, nothing to do
      Case Else
         Exit Function
   End Select

   Call pdf.CreateNewPDF(vbNullString)                         ' The output file is opened later
   Call pdf.SetDocInfo(TDocumentInfo.diProducer, vbNullString) ' No need to override the original producer

   ' These flags require some processing time but they are very useful.
   convFlags = convFlags Or TCheckOptions.coCheckImages Or TCheckOptions.coRepairDamagedImages

   ' The flag ifPrepareForPDFA is required. The flag ifImportAsPage makes sure that pages will not be converted to templates.
   Call pdf.SetImportFlags(TImportFlags.ifImportAll Or TImportFlags.ifImportAsPage Or TImportFlags.ifPrepareForPDFA)
   ' The flag if2UseProxy reduces the memory usage.
   Call pdf.SetImportFlags2(TImportFlags2.if2UseProxy)

   retval = pdf.OpenImportFile(InFile, TPwdType.ptOpen, vbNullString)
   If retval < 0 Then
      If pdf.IsWrongPwd(retval) Then
         Call MsgBox("PDFError File is encrypted!")
      End If
      Call pdf.FreePDF
      Exit Function
   End If
   Call pdf.ImportPDFFile(1, 1#, 1#)
   Call pdf.CloseImportFile

   ' The invoice should be the first attachment if further files must be attached.
   ' If the file name of the invoice is not factur-x.xml (case sensitive!) then use AttachFileEx() instead.
   ' In the case of the German XRechnung the file name must be "xrechnung.xml".

   Dim ef As Integer
   ef = pdf.AttachFile(Invoice, "EN 16931 compliant invoice", False)
   If ConfType <> TConformanceType.ctFacturX_XRechnung Then
      Call pdf.AssociateEmbFile(TAFDestObject.adCatalog, -1, TAFRelationship.arAlternative, ef)
   Else
      Call pdf.AssociateEmbFile(TAFDestObject.adCatalog, -1, TAFRelationship.arSource, ef)
   End If

   ' An invoice should not use CMYK colors since a CMYK ICC profile must be embedded in this case and such a profile is pretty large!
   ' Note that this code requires the PDF/A Extension for DynaPDF.
   retval = pdf.CheckConformance(ConfType, convFlags, ObjPtr(Me), AddressOf FontNotFoundProc, AddressOf ReplaceICCProfileProc)
   Select Case retval
      Case 1
         pdf.AddOutputIntent ("../../../test_files/sRGB.icc")
      Case 2
         pdf.AddOutputIntent ("../../../test_files/ISOcoated_v2_bas.ICC")
      Case 3
         pdf.AddOutputIntent ("../../../test_files/gray.icc")
   End Select
   ' No fatal error occurred?
   If pdf.HaveOpenDoc() Then
      If Not pdf.OpenOutputFile(OutFile) Then
         Call pdf.FreePDF
         Exit Function
      End If
      ConvertFile = pdf.CloseFile()
   End If
End Function

Private Sub Command1_Click()

   Dim OutFile As String
   OutFile = App.Path & "\out.pdf"

   ' The profiles Minimum, Basic, and Basic WL are not EN 16931 compliant and hence cannot be used to create e-invoices.
   If ConvertFile(TConformanceType.ctFacturX_Comfort, "../../../test_files/test_invoice.pdf", "../../../test_files/factur-x.xml", OutFile) Then
      ShellExecuteA Me.hWnd, "open", OutFile, vbNullString, vbNullString, 1
   End If

End Sub

Private Sub Form_Load()
   On Error GoTo Err
   Set pdf = New CPDF
   ' Set the license key here if you have one
   ' Call pdf.SetLicenseKey("")

   ' Non embedded CID fonts depend usually on the availability of external cmaps.
   ' External cmaps should be loaded if possible.
   Call pdf.SetCMapDir(GetFullPath("../../../Resource/CMap"), TLoadCMapFlags.lcmDelayed Or TLoadCMapFlags.lcmRecursive)
   Exit Sub
Err:
   MsgBox "Out of memory!", vbCritical, "Fatal error"
End Sub

Private Sub Form_Terminate()
   Set pdf = Nothing
End Sub
